# 画面設計書 152-Cat インデックス

## 概要

本ドキュメントは、OpenSearchのCat Indices API（`GET /_cat/indices`）エンドポイントに関する画面設計書である。インデックスの概要情報（プライマリ・レプリカ数、ドキュメント数、ディスクサイズ等）をテーブル形式で返すAPIの仕様を定義する。

### 本画面の処理概要

**業務上の目的・背景**：クラスタ内の全インデックスまたは特定インデックスの状態を一覧形式で確認するために使用される。インデックスのヘルス状態、ドキュメント数、ストアサイズ、シャード構成など、運用上必要な情報を一度に取得できるため、インデックス管理やキャパシティプランニングに不可欠なAPIである。ページネーション対応やレスポンス制限機能も備えている。

**画面へのアクセス方法**：HTTPクライアントから `GET /_cat/indices` または `GET /_cat/indices/{index}` にリクエストを送信してアクセスする。特定インデックスを指定可能で、ワイルドカードにも対応する。

**主要な操作・処理内容**：
1. GetSettingsRequestで認可済みインデックスを解決する
2. ClusterStateRequestでインデックスメタデータを取得する
3. IndicesStatsRequestでインデックス統計情報を取得する
4. ClusterHealthRequestでインデックスごとのヘルス状態を取得する
5. 4つのレスポンスを統合してテーブルを構築する

**画面遷移**：本APIはステートレスなREST APIである。インデックス統計API（`GET /{index}/_stats`）やクラスタヘルスAPI（`GET /_cluster/health`）と関連する情報を統合して表示する。

**権限による表示制御**：セキュリティプラグインが有効な場合、GetSettings APIの結果に基づいて表示対象インデックスがフィルタリングされる。ユーザーがアクセス権を持つインデックスのみが返される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 105 | インデックス統計 | 主機能 | インデックス情報をテーブル形式で返す処理 |

## 画面種別

一覧（テーブル形式のインデックス情報表示）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET | `/_cat/indices` | 全インデックス情報をテーブル形式で返す |
| GET | `/_cat/indices/{index}` | 指定インデックス情報をテーブル形式で返す |

## 入出力項目

### リクエストパラメータ

| パラメータ名 | 型 | 必須 | デフォルト | 説明 |
|-------------|------|------|-----------|------|
| index | list | No | - | インデックス名のカンマ区切りリスト（パスパラメータ） |
| format | string | No | - | レスポンス形式（json, yamlなど） |
| bytes | enum | No | - | バイト値の表示単位（b/k/kb/m/mb/g/gb/t/tb/p/pb） |
| local | boolean | No | false | ローカル情報を返す |
| cluster_manager_timeout | time | No | 30s | クラスタマネージャノードへの接続タイムアウト |
| master_timeout | time | No | 30s | **非推奨**: cluster_manager_timeoutを使用 |
| h | list | No | - | 表示するカラム名のカンマ区切りリスト |
| health | enum | No | - | ヘルスステータスフィルタ（green/yellow/red） |
| help | boolean | No | false | ヘルプ情報を返す |
| pri | boolean | No | false | プライマリシャードのみの統計を返す |
| s | list | No | - | ソートするカラム名のカンマ区切りリスト |
| time | enum | No | - | 時間値の表示単位（d/h/m/s/ms/micros/nanos） |
| v | boolean | No | false | 冗長モード。カラムヘッダーを表示 |
| include_unloaded_segments | boolean | No | false | メモリにロードされていないセグメント統計を含む |
| expand_wildcards | enum | No | all | ワイルドカード展開対象（open/closed/hidden/none/all） |

## 表示項目

### デフォルト表示カラム

| カラム名 | エイリアス | 説明 |
|---------|-----------|------|
| health | h | インデックスヘルスステータス |
| status | s | open/closeステータス |
| index | i,idx | インデックス名 |
| uuid | id | インデックスUUID |
| pri | p | プライマリシャード数 |
| rep | r | レプリカシャード数 |
| docs.count | dc | ドキュメント数 |
| docs.deleted | dd | 削除済みドキュメント数 |
| store.size | ss | ストアサイズ（プライマリ+レプリカ） |
| pri.store.size | - | プライマリのストアサイズ |

### 非デフォルト表示カラム（一部抜粋）

| カラム名 | エイリアス | 説明 |
|---------|-----------|------|
| creation.date | cd | インデックス作成日（ミリ秒） |
| creation.date.string | cds | インデックス作成日（文字列） |
| completion.size | cs | 補完サイズ |
| fielddata.memory_size | fm | フィールドデータキャッシュ使用量 |
| query_cache.memory_size | qcm | クエリキャッシュ使用量 |
| request_cache.memory_size | rcm | リクエストキャッシュ使用量 |
| segments.count | sc | セグメント数 |
| search.query_total | sqto | クエリフェーズ総数 |
| indexing.index_total | iito | インデキシング操作総数 |
| search.throttled | sth | 検索スロットル状態 |

## イベント仕様

### 1-GETリクエスト受信

クライアントからのGETリクエストを受信すると、`RestIndicesAction.doCatRequest()` が呼び出される。4つの内部リクエスト（GetSettings、ClusterState、IndicesStats、ClusterHealth）をGroupedActionListenerを使って並行発行し、全レスポンス受信後にテーブルを構築する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| GETリクエスト | - | SELECT | 参照のみ。データベースへの更新は発生しない |

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|-------------|
| 正常応答 | インデックス情報取得成功時 | テーブル形式のインデックス情報 |
| エラー | レスポンス制限超過時 | "Too many indices requested." |
| 警告 | master_timeoutパラメータ使用時 | 非推奨パラメータの使用警告 |

## 例外処理

- ResponseLimitBreachedException: インデックス数がレスポンス制限を超過した場合に発生
- OpenSearchParseException: master_timeoutとcluster_manager_timeoutの両方が指定された場合に発生
- インデックスが存在しない場合：空のレスポンスまたは404エラー

## 備考

- AbstractListActionを継承し、ページネーション対応の基盤を持つ
- ResponseLimitSettingsによるインデックス数制限が適用される
- healthパラメータでヘルスステータスフィルタリングが可能
- 全カラム数は100以上あり、hパラメータで必要なカラムのみ選択可能

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

4つの内部レスポンスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GetSettingsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/settings/get/GetSettingsResponse.java` | インデックス設定情報（認可済みインデックスの解決に使用） |
| 1-2 | ClusterStateResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/state/ClusterStateResponse.java` | クラスタ状態（IndexMetadata含む） |
| 1-3 | IndicesStatsResponse.java | `server/src/main/java/org/opensearch/action/admin/indices/stats/IndicesStatsResponse.java` | インデックス統計情報 |
| 1-4 | ClusterHealthResponse.java | `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthResponse.java` | インデックス別ヘルス情報 |

**読解のコツ**: 4つのレスポンスはGroupedActionListenerで集約される。全レスポンス到着後にbuildTableが呼ばれる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestIndicesAction.java` | Cat Indices APIのエントリーポイント |

**主要処理フロー**:
1. **行142-256**: `doCatRequest()` で4つの内部リクエストを順次/並行発行
2. **行275-291**: `sendGetSettingsRequest()` で認可済みインデックスを解決
3. **行293-309**: `sendClusterStateRequest()` でクラスタ状態を取得
4. **行329-344**: `sendIndicesStatsRequest()` でインデックス統計を取得
5. **行311-327**: `sendClusterHealthRequest()` でヘルス情報を取得
6. **行415-889**: `getTableWithHeader()` でテーブルヘッダー定義（100以上のカラム）
7. **行892-1230**: `buildTable()` でテーブル行構築

#### Step 3: レスポンス制限を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ResponseLimitSettings.java | `server/src/main/java/org/opensearch/common/breaker/ResponseLimitSettings.java` | レスポンス制限の設定管理 |

### プログラム呼び出し階層図

```
RestIndicesAction.doCatRequest() [行142]
    |
    +-- sendGetSettingsRequest() [行275]
    |       +-- client.admin().indices().getSettings()
    |
    +-- sendClusterStateRequest() [行293]
    |       +-- client.admin().cluster().state()
    |           +-- validateRequestLimit() [行258]
    |
    +-- sendIndicesStatsRequest() [行329]
    |       +-- client.admin().indices().stats()
    |
    +-- sendClusterHealthRequest() [行311]
    |       +-- client.admin().cluster().health()
    |
    +-- createGroupedListener() [行346]
            +-- buildTable() [行892]
                +-- getTableWithHeader() [行415]
                +-- RestTable.buildResponse()
```

### データフロー図

```
[入力]                        [処理]                           [出力]

GET /_cat/indices         --> RestIndicesAction               --> テーブル形式
    ?health=green              .doCatRequest()
    &bytes=mb                      |
                              +----+----+----+
                              |    |    |    |
                              v    v    v    v
                          GetSettings  ClusterState  IndicesStats  ClusterHealth
                              |    |    |    |
                              +----+----+----+
                                   |
                                   v
                              GroupedActionListener
                                   |
                                   v
                              buildTable() --> RestTable.buildResponse()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestIndicesAction.java | `server/src/main/java/org/opensearch/rest/action/cat/RestIndicesAction.java` | ソース | Cat Indices APIのRESTハンドラ |
| AbstractListAction.java | `server/src/main/java/org/opensearch/rest/action/list/AbstractListAction.java` | ソース | ページネーション対応リストアクション基底クラス |
| AbstractCatAction.java | `server/src/main/java/org/opensearch/rest/action/cat/AbstractCatAction.java` | ソース | Cat API共通基底クラス |
| RestTable.java | `server/src/main/java/org/opensearch/rest/action/cat/RestTable.java` | ソース | テーブルレンダリング処理 |
| ResponseLimitSettings.java | `server/src/main/java/org/opensearch/common/breaker/ResponseLimitSettings.java` | ソース | レスポンス制限設定 |
| cat.indices.json | `rest-api-spec/src/main/resources/rest-api-spec/api/cat.indices.json` | 設定 | REST API仕様定義 |
